import { View, Text } from 'react-native';
import React from 'react';
import { singleProductStyle } from './singleProduct.style';
import StarIcon from '../../../assets/svgs/product details/Star.svg';
import dpr from '../../../screens/Utilities/CustomStyleAttribute/dpr';
import useLangTranslation from '../../../hooks/useLangTranslation';
import usePreferences from '../../../hooks/usePreferences';
import CustomSVG from '../CustomSVG/CustomSVG';

const ProductBadge = ({ data }) => {
    const {
        isOutOfStock,
        featured,
        offerCheck,
        discountPercent,
        review_average,
    } = data || {};
    const { trans } = useLangTranslation();
    const { product_inventory: { out_of_stock_visibility } = {} } =
        usePreferences();
    return (
        <>
            {featured != null && (
                <Text style={singleProductStyle.featuredBadge}>
                    {trans('Featured')}
                </Text>
            )}
            {offerCheck == true && (
                <Text style={singleProductStyle.offBadge}>
                    {`${Number(discountPercent).toFixed(2)}% OFF`}
                </Text>
            )}
            {review_average == 5 && (
                <View style={singleProductStyle.topRatedBadgeCont}>
                    <CustomSVG svgIcon={StarIcon}
                        fill={'#FFFFFF'}
                        height={dpr(11)}
                        width={dpr(11)}
                    />
                    <Text style={singleProductStyle.topRatedBadge}>
                        {trans('Top Rated')}
                    </Text>
                </View>
            )}
            {out_of_stock_visibility == 1 &&
                isOutOfStock?.outOfStockVisibility == 1 && (
                    <Text style={singleProductStyle.outStockBadge}>
                        {trans('Stock Out')}
                    </Text>
                )}
        </>
    );
};

export default ProductBadge;
